<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T16:29:32.298958857 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-X1" />
    <supported-cpuid id="Cortex-X1C" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Bound">
        <series color="19,148,180" description="This metric is the percentage of total slots that were stalled due to resource constraints in the backend of the processor" expression="if(($BackendBoundCortexX1CPU_CYCLES &gt; 0), min(($BackendBoundCortexX1STALL_SLOT_BACKEND / (8 * $BackendBoundCortexX1CPU_CYCLES)), 1), 0)" name="Backend Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Memory Bound">
        <series color="19,148,180" description="This metric is the percentage of backend stalled cycles that were stalled due a miss in the last level of cache" expression="if(($BackendMemoryBoundCortexX1STALL_BACKEND &gt; 0), min(($BackendMemoryBoundCortexX1STALL_BACKEND_MEM / $BackendMemoryBoundCortexX1STALL_BACKEND), 1), 0)" name="Backend Memory Bound" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Stalled Cycles">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesCortexX1CPU_CYCLES &gt; 0), min(($BackendStalledCyclesCortexX1STALL_BACKEND / $BackendStalledCyclesCortexX1CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Barrier Operations Percentage">
        <series color="19,148,180" description="This metric measures instruction and data barrier operations as a percentage of operations speculatively executed" expression="if(($BarrierOperationsPercentageCortexX1INST_SPEC &gt; 0), min(((($BarrierOperationsPercentageCortexX1ISB_SPEC + $BarrierOperationsPercentageCortexX1DSB_SPEC) + $BarrierOperationsPercentageCortexX1DMB_SPEC) / $BarrierOperationsPercentageCortexX1INST_SPEC), 1), 0)" name="Barrier Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Misprediction Percentage">
        <series color="19,148,180" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageCortexX1BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageCortexX1BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageCortexX1BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch MPKI">
        <series color="19,148,180" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexX1INST_RETIRED &gt; 0), (($BranchMPKICortexX1BR_MIS_PRED_RETIRED / $BranchMPKICortexX1INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Operations Percentage">
        <series color="19,148,180" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageCortexX1INST_SPEC &gt; 0), min((($BranchOperationsPercentageCortexX1BR_IMMED_SPEC + $BranchOperationsPercentageCortexX1BR_INDIRECT_SPEC) / $BranchOperationsPercentageCortexX1INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Cycles Per Instruction">
        <series color="19,148,180" description="This metric measures the number of cycles per instructions retired" expression="if(($CyclesPerInstructionCortexX1INST_RETIRED &gt; 0), ($CyclesPerInstructionCortexX1CPU_CYCLES / $CyclesPerInstructionCortexX1INST_RETIRED), 0)" name="Cycles Per Instruction" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Crypto Operations Percentage">
        <series color="19,148,180" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexX1INST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexX1CRYPTO_SPEC / $CryptoOperationsPercentageCortexX1INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="DTLB MPKI">
        <series color="19,148,180" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKICortexX1INST_RETIRED &gt; 0), (($DTLBMPKICortexX1DTLB_WALK / $DTLBMPKICortexX1INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="DTLB Walk Percentage">
        <series color="19,148,180" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageCortexX1L1D_TLB &gt; 0), min(($DTLBWalkPercentageCortexX1DTLB_WALK / $DTLBWalkPercentageCortexX1L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Stalled Cycles">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesCortexX1CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesCortexX1STALL_FRONTEND / $FrontendStalledCyclesCortexX1CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageCortexX1INST_SPEC &gt; 0), min((($IntegerOperationsPercentageCortexX1DP_SPEC - $IntegerOperationsPercentageCortexX1DSB_SPEC) / $IntegerOperationsPercentageCortexX1INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions Per Cycle">
        <series color="19,148,180" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexX1CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexX1INST_RETIRED / $InstructionsPerCycleCortexX1CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="ITLB MPKI">
        <series color="19,148,180" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKICortexX1INST_RETIRED &gt; 0), (($ITLBMPKICortexX1ITLB_WALK / $ITLBMPKICortexX1INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ITLB Walk Percentage">
        <series color="19,148,180" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageCortexX1L1I_TLB &gt; 0), min(($ITLBWalkPercentageCortexX1ITLB_WALK / $ITLBWalkPercentageCortexX1L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache Demand MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheDemandMPKICortexX1INST_RETIRED &gt; 0), ((($L1DCacheDemandMPKICortexX1L1D_CACHE_REFILL_RD + $L1DCacheDemandMPKICortexX1L1D_CACHE_REFILL_WR) / $L1DCacheDemandMPKICortexX1INST_RETIRED) * 1000), 0)" name="L1D Cache Demand MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexX1L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexX1L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexX1L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexX1INST_RETIRED &gt; 0), (($L1DCacheMPKICortexX1L1D_CACHE_REFILL / $L1DCacheMPKICortexX1INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageCortexX1L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageCortexX1L1D_TLB_REFILL / $L1DataTLBMissPercentageCortexX1L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexX1INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexX1L1D_TLB_REFILL / $L1DataTLBMPKICortexX1INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1I Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexX1L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexX1L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexX1L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1I Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexX1INST_RETIRED &gt; 0), (($L1ICacheMPKICortexX1L1I_CACHE_REFILL / $L1ICacheMPKICortexX1INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageCortexX1L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageCortexX1L1I_TLB_REFILL / $L1InstructionTLBMissPercentageCortexX1L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexX1INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexX1L1I_TLB_REFILL / $L1InstructionTLBMPKICortexX1INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache accesses missed to the total number of level 2 cache accesses. This gives an indication of the effectiveness of the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMissPercentageCortexX1L2D_CACHE &gt; 0), min(($L2CacheMissPercentageCortexX1L2D_CACHE_REFILL / $L2CacheMissPercentageCortexX1L2D_CACHE), 1), 0)" name="L2 Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKICortexX1INST_RETIRED &gt; 0), (($L2CacheMPKICortexX1L2D_CACHE_REFILL / $L2CacheMPKICortexX1INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageCortexX1L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageCortexX1L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageCortexX1L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKICortexX1INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKICortexX1L2D_TLB_REFILL / $L2UnifiedTLBMPKICortexX1INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Cache Demand MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache data demand accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheDemandMPKICortexX1INST_RETIRED &gt; 0), ((($L2DCacheDemandMPKICortexX1L2D_CACHE_REFILL_RD + $L2DCacheDemandMPKICortexX1L2D_CACHE_REFILL_WR) / $L2DCacheDemandMPKICortexX1INST_RETIRED) * 1000), 0)" name="L2D Cache Demand MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 cache data accesses missed to the total number of level 2 data cache accesses. This gives an indication of the effectiveness of data accesses in the level 2 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMissPercentageCortexX1L2D_CACHE &gt; 0), min(($L2DCacheMissPercentageCortexX1L2D_CACHE_REFILL / $L2DCacheMissPercentageCortexX1L2D_CACHE), 1), 0)" name="L2D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache data accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMPKICortexX1INST_RETIRED &gt; 0), (($L2DCacheMPKICortexX1L2D_CACHE_REFILL / $L2DCacheMPKICortexX1INST_RETIRED) * 1000), 0)" name="L2D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageCortexX1L3D_CACHE &gt; 0), min(($L3CacheMissPercentageCortexX1L3D_CACHE_REFILL / $L3CacheMissPercentageCortexX1L3D_CACHE), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKICortexX1INST_RETIRED &gt; 0), (($L3CacheMPKICortexX1L3D_CACHE_REFILL / $L3CacheMPKICortexX1INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load-Exclusive Instructions Percentage">
        <series color="19,148,180" description="This metric measures load-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($LoadExclusiveInstructionsPercentageCortexX1INST_SPEC &gt; 0), min(($LoadExclusiveInstructionsPercentageCortexX1LDREX_SPEC / $LoadExclusiveInstructionsPercentageCortexX1INST_SPEC), 1), 0)" name="Load-Exclusive Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LL Cache Read Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageCortexX1LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageCortexX1LL_CACHE_RD - $LLCacheReadHitPercentageCortexX1LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageCortexX1LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LL Cache Read Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageCortexX1LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageCortexX1LL_CACHE_MISS_RD / $LLCacheReadMissPercentageCortexX1LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="LL Cache Read MPKI">
        <series color="19,148,180" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKICortexX1INST_RETIRED &gt; 0), (($LLCacheReadMPKICortexX1LL_CACHE_MISS_RD / $LLCacheReadMPKICortexX1INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load Operations Percentage">
        <series color="19,148,180" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageCortexX1INST_SPEC &gt; 0), min(($LoadOperationsPercentageCortexX1LD_SPEC / $LoadOperationsPercentageCortexX1INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load-Acquire Instructions Percentage">
        <series color="19,148,180" description="This metric measures memory-read instructions with acquire or acquirepc semantics as a percentage of instructions speculatively executed" expression="if(($LoadAcquireInstructionsPercentageCortexX1INST_SPEC &gt; 0), min(($LoadAcquireInstructionsPercentageCortexX1RC_LD_SPEC / $LoadAcquireInstructionsPercentageCortexX1INST_SPEC), 1), 0)" name="Load-Acquire Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Release Instructions Percentage">
        <series color="19,148,180" description="This metric measures memory-write instructions with release semantics as a percentage of instructions speculatively executed" expression="if(($StoreReleaseInstructionsPercentageCortexX1INST_SPEC &gt; 0), min(($StoreReleaseInstructionsPercentageCortexX1RC_ST_SPEC / $StoreReleaseInstructionsPercentageCortexX1INST_SPEC), 1), 0)" name="Store-Release Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Retired Operations Percentage">
        <series color="19,148,180" description="This metric measures the percentage of operations speculatively executed that are subsequently retired" expression="if(($RetiredOperationsPercentageCortexX1OP_SPEC &gt; 0), min(($RetiredOperationsPercentageCortexX1OP_RETIRED / $RetiredOperationsPercentageCortexX1OP_SPEC), 1), 0)" name="Retired Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Retiring">
        <series color="19,148,180" description="This metric is the percentage of total slots that retired operations, which indicates cycles that were utilized efficiently" expression="if(($RetiringCortexX1CPU_CYCLES &gt; 0) &amp;&amp; ($RetiringCortexX1OP_SPEC &gt; 0), min(((1 - ($RetiringCortexX1STALL_SLOT / ($RetiringCortexX1CPU_CYCLES * 8))) * ($RetiringCortexX1OP_RETIRED / $RetiringCortexX1OP_SPEC)), 1), 0)" name="Retiring" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexX1INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexX1VFP_SPEC / $FloatingPointOperationsPercentageCortexX1INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Advanced SIMD Operations Percentage">
        <series color="19,148,180" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexX1INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexX1ASE_SPEC / $AdvancedSIMDOperationsPercentageCortexX1INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageCortexX1INST_SPEC &gt; 0), min(($StoreOperationsPercentageCortexX1ST_SPEC / $StoreOperationsPercentageCortexX1INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Store-Exclusive Failures PKI">
        <series color="19,148,180" description="This metric measures the number of store-exclusive instructions that failed per thousand instructions speculatively executed" expression="if(($StoreExclusiveFailuresPKICortexX1INST_SPEC &gt; 0), (($StoreExclusiveFailuresPKICortexX1STREX_FAIL_SPEC / $StoreExclusiveFailuresPKICortexX1INST_SPEC) * 1000), 0)" name="Store-Exclusive Failures PKI" units="failures"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Exclusive Failures Percentage">
        <series color="19,148,180" description="This metric measures the number of store-exclusive instructions that failed as a percentage of store-exclusive instructions speculatively executed" expression="if(($StoreExclusiveFailuresPercentageCortexX1STREX_SPEC &gt; 0), min(($StoreExclusiveFailuresPercentageCortexX1STREX_FAIL_SPEC / $StoreExclusiveFailuresPercentageCortexX1STREX_SPEC), 1), 0)" name="Store-Exclusive Failures Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store-Exclusive Instructions Percentage">
        <series color="19,148,180" description="This metric measures store-exclusive instructions as a percentage of instructions speculatively executed" expression="if(($StoreExclusiveInstructionsPercentageCortexX1INST_SPEC &gt; 0), min(($StoreExclusiveInstructionsPercentageCortexX1STREX_SPEC / $StoreExclusiveInstructionsPercentageCortexX1INST_SPEC), 1), 0)" name="Store-Exclusive Instructions Percentage" units="percent"/>
    </chart>
    <select-metric id="ARMv8_Cortex_X1_metric_backend_bound" />
    <select-metric id="ARMv8_Cortex_X1_metric_backend_mem_bound" />
    <select-metric id="ARMv8_Cortex_X1_metric_backend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_X1_metric_barrier_percentage" />
    <select-metric id="ARMv8_Cortex_X1_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv8_Cortex_X1_metric_branch_mpki" />
    <select-metric id="ARMv8_Cortex_X1_metric_branch_percentage" />
    <select-metric id="ARMv8_Cortex_X1_metric_cpi" />
    <select-metric id="ARMv8_Cortex_X1_metric_crypto_percentage" />
    <select-metric id="ARMv8_Cortex_X1_metric_dtlb_mpki" />
    <select-metric id="ARMv8_Cortex_X1_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_X1_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_X1_metric_integer_dp_percentage" />
    <select-metric id="ARMv8_Cortex_X1_metric_ipc" />
    <select-metric id="ARMv8_Cortex_X1_metric_itlb_mpki" />
    <select-metric id="ARMv8_Cortex_X1_metric_itlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_X1_metric_l1d_cache_demand_mpki" />
    <select-metric id="ARMv8_Cortex_X1_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_X1_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_X1_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_X1_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_X1_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_X1_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Cortex_X1_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_X1_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_X1_metric_l2_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_X1_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Cortex_X1_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_X1_metric_l2_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_X1_metric_l2d_cache_demand_mpki" />
    <select-metric id="ARMv8_Cortex_X1_metric_l2d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_X1_metric_l2d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_X1_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_X1_metric_l3_cache_mpki" />
    <select-metric id="ARMv8_Cortex_X1_metric_ldrex_percentage" />
    <select-metric id="ARMv8_Cortex_X1_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv8_Cortex_X1_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv8_Cortex_X1_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv8_Cortex_X1_metric_load_percentage" />
    <select-metric id="ARMv8_Cortex_X1_metric_rc_ld_percentage" />
    <select-metric id="ARMv8_Cortex_X1_metric_rc_st_percentage" />
    <select-metric id="ARMv8_Cortex_X1_metric_retired_ops_percent" />
    <select-metric id="ARMv8_Cortex_X1_metric_retiring" />
    <select-metric id="ARMv8_Cortex_X1_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Cortex_X1_metric_simd_percentage" />
    <select-metric id="ARMv8_Cortex_X1_metric_store_percentage" />
    <select-metric id="ARMv8_Cortex_X1_metric_strex_fail_mpki" />
    <select-metric id="ARMv8_Cortex_X1_metric_strex_fail_percent" />
    <select-metric id="ARMv8_Cortex_X1_metric_strex_percentage" />
</template>
